#ifndef CLIPARSE_H
#define	CLIPARSE_H

#define MAX_CMD_ARGS    10
#define CMD_MAX_LENGTH  256u
#define CMD_ID_INVALID  0

typedef int(*CMD_FNC)(int argc, char **argv);

typedef struct
{
	const char*     cmdStr;        // string identifying the command
	CMD_FNC         cmdFnc;        // function to execute for this command
	const char*     cmdDescr;      // simple command description
} CMD_DESCRIPTOR;              // a simple command descriptor

extern const CMD_DESCRIPTOR commandsTable[];

/************************************
		ATTENUATOR COMMANDS
************************************/

#define CMD_STR_SELECT_DEVICE	    "SELECT"
#define CMD_STR_SET_ALL_ATTEN       "SAA" 
#define CMD_STR_SET_ATTEN           "SET"
#define CMD_STR_SET_INDIVID_ATTEN   "SET_IND"
#define CMD_STR_RAMP                "RAMP"
#define CMD_STR_RAND                "RAND"
#define CMD_STR_RAND_ALL            "RANDALL"
#define CMD_STR_RAND_LOOP           "RANDLOOP"
#define CMD_STR_STATUS              "STATUS"
#define CMD_STR_SET_DEFAULT         "DEFAULT_ATTEN"
#define CMD_STR_SET_AUTO            "ATTEN_AUTOSAVE"
#define CMD_STR_GROUP_SET           "GROUP_SET"
#define CMD_STR_GROUP_ADD           "GROUP_ADD"
#define CMD_STR_GROUP_REMOVE        "GROUP_REMOVE"
#define CMD_STR_GROUP_GET           "GROUPS"
#define CMD_STR_GROUPS_DEFAULT      "GROUPS_DEFAULT"
#define CMD_STR_GROUP_INCREMENT     "GROUP_INC"
#define CMD_STR_GROUP_DECREMENT     "GROUP_DEC"
#define CMD_STR_GROUPS_EQUALIZE     "GROUPS_EQU"
#define CMD_STR_GROUP_NAME          "GROUP_NAME"

/************************************
		   MISC COMMANDS
************************************/

#define CMD_STR_HELP                "HELP"
#define CMD_STR_RESET               "RESET"
#define CMD_STR_SET_BOOTLOAD        "FW_BOOTLOAD"
#define CMD_STR_INFO                "INFO"
#define CMD_STR_LOCATE              "LOCATE"

/************************************
		ETHERNET COMMANDS
************************************/

#define CMD_STR_DHCP                "DHCP"
#define CMD_STR_IP                  "IP"
#define CMD_STR_GATEWAY             "GW"
#define CMD_STR_SUBNET              "NETMASK"
#define CMD_STR_SAVE_SETTINGS       "ETH_SAVE"
#define CMD_STR_DEFAULT_SETTINGS    "ETH_DEFAULT"

/************************************
		TELNET COMMANDS
************************************/
#define CMD_STR_TELNET_AUTOLOGIN    "TELNET_AUTOLOGIN"
#define CMD_STR_TELNET_NOTICE       "TELNET_NOTICE"
#define CMD_STR_TELNET_LOGIN        "TELNET_USER"
#define CMD_STR_TELNET_PASS         "TELNET_PASSWORD"
#define CMD_STR_TELNET_STATUS       "TELNET_STATUS"

int CommandParse(char* cmdline);
int GetCommandsCount();

int CommandSelect(int argc, char** argv);
int CommandSaa(int argc, char** argv);
int CommandSet(int argc, char** argv);
int CommandStatus(int argc, char** argv);
int CommandInfo(int argc, char** argv);
int CommandHelp(int argc, char** argv);

#endif	/* CLIPARSE_H */